---
pageId: "default"
title: "Untitled"
order: 0
---

# PaperX

PaperX は、開発中のアプリケーションのコードネーム

今目指している姿を一言で言えば、AI エージェントとのコラボレーションに特化したドキュメントツール。

パッと見では Google Docs や Notion のように見えるが、より優れた AI ネイティブな体験を目指している。


## Information

- GitHub
- https://github.com/paperxlab/app
- 今は private で、将来的に OSS にする可能性もある
- 検証環境
- https://paperxlab.xyz
- 開発者本人が使う用で、全世界からアクセスできるが、認証も何もない状態


## ステータス

今は開発中で、リリースされていない。一人の開発者本人が、PaperX 自体を作ったり、他のクライアントワークを進める中で本当に価値があるかを検証しながら開発を続けていく。


## 機能

今ある機能としては、ざっくり以下のもの

### ドキュメント

Google Docs に近い見た目で、今は3カラムの構成。

真ん中のメインカラムにブロックベースのリッチテキストエディタがある

左カラムには、ページの一覧がある。一つのドキュメントに複数のページを持てるのが、Notion とは違うところ。

このアプリケーションでは、ドキュメントが一つの GitHub Repository のように扱われる。

ファイルのように複数のページを持てることに加えて、ブランチ機能を持つ。ブランチを切ると、その時点でのドキュメントの状態が分岐する。これはメタデータがコピーされるだけで、実際の内容はコピーされずに追加の更新だけ別のタイムラインに書き込まれるような仕組みなので、非常に軽量である。

このブランチ機能を使って、AI エージェントが並行して動き、タスクごとのブランチに結果を書き込んで、pull request のように内容をレビューして、変更を取り込むことができる。

右カラムには AI パネルがあり、Chat と Edits の 2 つのタブを切り替えて使う。Chat タブでは、閲覧中のページやドキュメント全体をコンテキストに AI と会話し、内容理解や次にやるべき編集の相談ができる。Edits タブでは、記事の編集を AI エージェントに指示でき、編集作業はタスクごとのブランチ上でバックグラウンド実行される。

Edits を作成する際は、コンテキストにしたい Chat（会話スレッド）を複数選んで渡せる。Chat での議論を土台に Edits を走らせることで、相談から変更作成までを連続的に扱えるようにしている。生成された変更は diff ビューでレビューして取り込めるが、まだプロトタイプレベルで細かなバグが残っている。Chat と Edits は現状タブでプリミティブに分かれているが、今後は会話から編集までをよりシームレスに繋げていく方針。


## 技術

テキストエディタ部分は、ProseMirror ベースのもの。簡単のために Tiptap を利用しているが、Tiptap にはあまり依存したくない。

共同編集のためのコアなデータモデルとして Yjs を独自にフォークしたものを使っている。このフォークでは、通常の Y.Doc のような巨大な一つのドキュメントを使うのではなくて、小さな Y.Doc をリンクさせて使えるようにする構成にすることで、データの肥大化を防いだり、変更の衝突を最小限にしたり、部分ロードを可能にしたり、様々なメリットがある。

また、そのデータ構造のためのバックエンドサーバーを自作しており、それらの更新データを PlanetScale に保存して高い耐久性とスケーラビリティを実現しようとしている。

これらのコアな技術にも価値があると感じていて、将来的にはこのコア技術を使ったさらなるビジネス展開なども考えているが、今はそれをベースにしたアプリケーションとしてビジネスを作り上げることにフォーカスしたい。

なので、ProseMirror と Yjs の同期は y-prosemirror を使わずに、独自の同期エンジンを使っている。

